#!/bin/bash

logFile="/home/HwHiAiUser/ascend_install.log"
username=HwHiAiUser
usergroup=HwHiAiUser
usageFile="./scripts/help.info"

# 开始安装前打印开始信息
startLog() {
    cur_date=`date +"%Y-%m-%d %H:%M:%S"`
    echo "InstallStart: ${cur_date}"
    echo "InstallStart: ${cur_date}" >> $logFile
}

# 写日志
log() {
    cur_date=`date +"%Y-%m-%d %H:%M:%S"`
    echo "[aicpu] [$cur_date] "$1 >> $logFile
}

# 参数使用
paramUsage() {
    echo "Usage: ./scripts/install.sh --arg1 [arg2 ...]"
    cat ${usageFile}
}

# change log file mode
changeLogMode() {
    if [ ! -f $logFile ]; then
        touch $logFile
    fi
    chmod 640 $logFile
}

# 检查用户是否存在
checkUser() {
    ret=`cat /etc/passwd | cut -f1 -d':' | grep -w "$1" -c`
    if [ $ret -le 0 ]; then
        return 1
    else
        return 0
    fi
}

createFile(){
    filePath="/usr/lib64/aicpu_kernels/aicpu_kernels.info"
    if [ ! -f "$filePath" ];then
        touch $filePath
        if [ $? -ne 0 ];then
            echo "create aicpu_kernels.info failed."
            log "[ERROR]create aicpu_kernels.info failed."
            exit 1
        else
            log "[INFO]create aicpu_kernels.info success."
        fi

        chmod 660 $filePath
        if [ $? -ne 0 ];then
            log "[ERROR]chmod for $filePath failed"
        fi

        chown -RPf $username:$usergroup $filePath
        if [ $? -ne 0 ];then
            log "[ERROR]chown for $filePath failed"
        fi
    else
        log "[INFO]aicpu_kernels.info already exists."
    fi
}
unalias cp
all_parma="$@"
echo "InputParams: $all_parma"
changeLogMode
log "[INFO]InputParams: $all_parma"
startLog

run_install=n
full_install=n
uninstall=n
upgrade=n
version=n
installmode=""
input_install_path=/usr/lib64/aicpu_kernels

while true
do
    case "$1" in
        --help | -h)
            paramUsage
            exit 0
            ;;
        --run)
            run_install=y
            installmode="run"
            shift
            ;;
        --full)
            full_install=y
            installmode="full"
            shift
            ;;
        --upgrade)
            upgrade=y
            installmode="upgrade"
            shift
            ;;
        --uninstall)
            uninstall=y
            shift
            ;;
        --install-path=*)
            input_install_path=`echo ${1} | sed "s/\/*$//g"`
            input_install_path=`echo ${input_install_path} | cut -d"=" -f2 `
            shift
            ;;
        --install-username*)
            username=`echo $1 | cut -d"=" -f2 `
            if [ -z $username ]; then
                echo "ERROR:input install_username is empty"
                log "[ERROR]input install_username is empty"
                exit 1
            else
                shift
            fi
            ;;
        --install-usergroup*)
            usergroup=`echo $1 | cut -d"=" -f2 `
            if [ -z $usergroup ]; then
                echo "ERROR:input install_group is empty"
                log "[ERROR]input install_group is empty"
                exit 1
            else
                shift
            fi
            ;;
        -*)
            echo "ERROR:Unsupported parameters : $1"
            log "[ERROR]Unsupported parameters : $1"
            paramUsage
            exit 0
            ;;
        *)
            break
            ;;
    esac
done

# check params confilct
if [ $uninstall = y ]; then
    # 卸载参数只支持单独使用
    if [ "${upgrade}" = y ] || [ "$full_install" = y ] || [ "$run_install" = y ]; then
        echo "ERROR:Unsupported parameters, operation failed."
        log "[ERROR]Unsupported parameters, operation failed."
        exit 1
    fi
    exit 0;
fi

echo "install path: "$input_install_path
log "[INFO]install path: $input_install_path"
# copy file to /usr/lib64/aicpu_kernels
install_file_path=$(dirname $(readlink -f "${0}"))
areaNum=`echo $install_file_path | awk -F'/' '{print NF}'`
current_path=`echo $install_file_path | cut -d'/' -f1-$(expr $areaNum - 1)`
filelist=$(ls ${current_path}/lib64)
target_path=/usr/lib64/aicpu_kernels
if [ -d ${target_path} ];then
    for file in ${filelist}
    do
        cp ${current_path}/lib64/${file} $target_path
        if [ $? -ne 0 ];then
            echo "ERROR:aicpu_kernels copy failed, installation failed!"
            log "[ERROR]aicpu_kernels copy failed, installation failed!"
            exit 1
        fi
        chmod 440 ${target_path}/${file}
        ret=$(id -u)
        if [ $ret -eq 0 ];then
            chown -RPf HwHiAiUser:HwHiAiUser ${target_path}/${file}
        fi
    done
fi

# cpoy version.info to /var/davinci/aicpu_kernels
if [ -d "/var/davinci/aicpu_kernels" ];then
    cp ${current_path}/version.info /var/davinci/aicpu_kernels
    ret=$(id -u)
    if [ $ret -eq 0 ];then
        chown -RPf HwHiAiUser:HwHiAiUser /var/davinci/aicpu_kernels/version.info
    fi
else
    ret=$(id -u)
    if [ $ret -eq 0 ];then
        mkdir -p /var/davinci/aicpu_kernels
        cp ${current_path}/version.info /var/davinci/aicpu_kernels
    fi
fi

# create /usr/lib64/aicpu_kernels.info
createFile

echo "aicpu_kernels installation success!"
log "[INFO]aicpu_kernels installation success!"

exit 0

